/*
Cour: STIC 4
Description: libraire permettant de faire un kit de chimie
Auteur: Victor Garretas Ruiz
*/

//Importation de la librairie DobloFactory permettant à nos pièces d'être posées sur des Legos
include <../DobloFactory/doblo-factory.scad>;
include <../DobloFactory/lib/doblo-params.scad>;


/*********************************
Table
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas et le plan de travail en lego ou pas.
    Valeurs acceptées: true ou false
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement la table
    Valeurs acceptées: true ou false
*/
module table_lego(lego=true, imprimer=true){
    if(lego == true){
        //base lego
        doblo(col=-9, row=-4, width=18, length=8, height=HALF, nibbles_on_off=false);
        //haut
        color("red"){
            block(col=-9, row=-4, width=10, length=8, height=HALF, up=6.5*FULL, nibbles_on_off=true);
        }
        //Table
        constructionTable();
        if(imprimer == false){
            //Robinet
            translate([40,22.5,60]){ 
                robinet();
            }
        }
        if(imprimer == true){
            //Robinet
            translate([100,0,3]){ 
                rotate(a = [-90,0,0]){
                    robinet();
                }
            }
        }
    }
    if(lego == false){    
        //base lego
        block(col=-9, row=-4, width=18, length=8, height=HALF, nibbles_on_off=false);
        //Table
        constructionTable();
        if(imprimer == false){
            //Robinet
            translate([40,22.5,60]){ 
                robinet();
            }
        }
        if(imprimer == true){
            //Robinet
            translate([100,0,3]){ 
                rotate(a = [-90,0,0]){
                    robinet();
                }
            }
        }
    }    
    
    module constructionTable(){
        //table
        difference(){
            union(){
               //Base de la table
               color("green"){ block(col=-9, row=-4, width=18, length=8, height=6*FULL, up=HALF, nibbles_on_off=false);}
               //Haut de la table
                hull(){
                    color("yellow"){
                        block(col=-10, row=-5, width=20, length=10, up=6*FULL, height=FULL, nibbles_on_off=false);
                        support (col=-9, row=4, height=HALF+1, up=5.5*FULL-1, angle=270, thickness=18, scale=LUGO);
                        support (col=9, row=-4, height=HALF+1, up=5.5*FULL-1, angle=0, thickness=8, scale=LUGO);
                        support (col=-9, row=-5, height=HALF+1, up=5.5*FULL-1, angle=90, thickness=18, scale=LUGO);
                        support (col=-10, row=-4, height=HALF+1, up=5.5*FULL-1, angle=180, thickness=8, scale=LUGO);
                    }
               }
            }//union
            //Lavabo
            color("blue"){
                block(col=2, row=-2, width=6, length=4.5, height=3*FULL, up=5*FULL, nibbles_on_off=false);
            }
            //On fait un trou pour le robinet
            translate([40,22.5,60]){ 
                robinet();
            }
         }//difference
         
        //Tirroirs
        translate ([0,-4.5,-2.2]){
            union(){
                //haut
                translate([28,-24,44]){
                    cube(size =[48,8,16], center = true);  
                }
                translate([28,-26,44]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }
                translate([-28,-24,44]){
                    cube(size =[48,8,16], center = true);  
                }
                translate([-28,-26,44]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }
                
                //Bas
                translate([40,-24,20]){
                    cube(size =[22,8,24], center = true);
                }
                translate([32,-26,20]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }
                translate([16,-24,20]){
                    cube(size =[22,8,24], center = true);
                }
                translate([24,-26,20]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }
                translate([-40,-24,20]){
                    cube(size =[22,8,24], center = true);
                }
                translate([-32,-26,20]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }        
                translate([-16,-24,20]){
                    cube(size =[22,8,24], center = true);
                }
                translate([-24,-26,20]){
                    rotate(a = [90,0,0]){
                       cylinder(h = 4, r = 1);
                    }
                }        
            }
        }
    }
    //Robinet
    module robinet(){
        //Tronc
        translate([0,0,0]){
            cylinder(h = 30, r = 3);
        }
        //Robinet Gauche
        translate([-19,0,27.5]){
            rotate(a = [0,90,0]){
                cylinder(h = 20, r = 2.5, $fn=15);
            }
        }
        translate([-19,0,27.5]){
            sphere(r = 2.5, $fn=15);
        }
        translate([-19,-20,27.5]){
            rotate(a = [0,90,90]){
                cylinder(h = 20, r = 2.5, $fn=15);
            }    
        } 
        translate([-19,-20,27.5]){
            sphere(r = 2.5, $fn=15);
        }             
        translate([-19,-20,20]){
            rotate(a = [0,0,0]){
                cylinder(h = 7.5, r = 2.5, $fn=15);
            }    
        }
        translate([-19,-17.5,27.5]){
            rotate(a = [0,0,0]){
                cylinder(h = 5, r = 2, $fn=15);
            }    
        }
        //Droite
        translate([-2,0,27.5]){
            rotate(a = [0,90,0]){
                cylinder(h = 20, r = 2.5, $fn=15);
            }    
        }
        translate([19,0,27.5]){
            sphere(r = 2.5, $fn=15);
        }
        translate([19,-20,27.5]){
            rotate(a = [0,90,90]){
                cylinder(h = 20, r = 2.5, $fn=15);
            }    
        }
        translate([19,-20,27.5]){
            sphere(r = 2.5, $fn=15);
        }
        translate([19,-20,20]){
            rotate(a = [0,0,0]){
                cylinder(h = 7.5, r = 2.5, $fn=15);
            }    
        }
        translate([19,-17.5,27.5]){
            rotate(a = [0,0,0]){
                cylinder(h = 5, r = 2, $fn=15);
            }    
        }
    }
}




/*********************************
Bécher
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le parametre remplissage sert à déterminer le remplissage du bécher en %.
    Valeurs acceptées: 0 à 100
*/
module becher(lego=true, remplissage=0){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionBecher(remplissage);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionBecher(remplissage);
    }    
    
    module constructionBecher(remplissage){ 
        translate([0,0,5]){
            difference(){
            union(){
            //Bas du bécher
            difference (){   
                scale([1, 1, 0.5]){    
                    sphere(r = 12);
                }
                translate([-15,-15,0]){
                    cube(size =[30,30,20]);
                }
                translate([-15,-15,-25]){
                    cube(size =[30,30,20]);
                }
            }
            
            //Corps du bécher
            difference(){
                cylinder(h = 30, r = 12);
                translate([0,0,2]){
                    cylinder(h = 30, r = 9);
                    }    
            }            
            
            //Haut du bécher (cylindre qui ressort)
            translate([0,0,30]){ 
                difference(){
                    translate([-4.5,0,-7]){
                        rotate(a=[0,-40,0]){ 
                            cylinder(h = 10, r = 5);
                        }
                        }
                    translate([0,0,4.9]){
                        cube(size =[30,30,10], center=true);   
                    }
                    translate([0,0,-15]){
                        cylinder(h = 20, r = 9);
                    } 
                    }
            }
        }//union
            //Partie pour enlever le bout arrondi qui sort du bécher
            translate([-5,0,23.2]){
                            rotate(a=[0,-40,0]){ 
                                cylinder(h = 15, r = 3);
                            }
                            }
        
        }//difference 
 
        //Remplissage du bécher
        translate([0,0,2]){            
            if(remplissage <= 100){
                remplissage = remplissage*0.01*20;
                cylinder(h = remplissage, r = 9);
            }
            if(remplissage > 100){
                remplissage = 0;
                cylinder(h = remplissage, r = 9);
            }
             if(remplissage < 0){
                remplissage = 0;
                cylinder(h = remplissage, r = 9);
            }           
        }
        
        }
    }    
}



/*********************************
Portoir tubes à essai
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement le portoir
    Valeurs acceptées: true ou false
*/
module supportTube(lego=true, imprimer=true){
    //Avec Lego
    if(lego == true){
        union(){
            translate([0,0,4]){
                piliers();
                if(imprimer == true){
                    translate([0,30,-3]){
                        rotate(a=[0,180,0]){
                            hautSupportTube(); 
                        }
                    }
                }
                if(imprimer == false){
                    translate([0,0,26]){
                        hautSupportTube(); 
                    }
                }
            }
            doblo(col=-3, row=-1.5, width=6, length=3, height=HALF, nibbles_on_off=false);
        }
    }
    //Sans Lego
    if(lego == false){
        union(){
            translate([0,0,4]){
                piliers(); 
                if(imprimer == true){
                    translate([0,30,-3]){
                        rotate(a=[0,180,0]){
                            hautSupportTube(); 
                        }
                    }
                }
                if(imprimer == false){
                    translate([0,0,26]){
                        hautSupportTube(); 
                    }
                }
            }
            block(col=-3, row=-1.5, width=6, length=3, height=HALF, nibbles_on_off=false);
        }
    }
    
    module piliers(){
        //Les piliers
        //Gauche
        translate([-18,0,0]){
            cylinder(h = 25, r = 4);
        }
        //Droite
        translate([18,0,0]){
            cylinder(h = 25, r = 4);
        }
    }
    
    module hautSupportTube(){            
        difference(){
        translate([0,0,-4]){            
            block(col=-3, row=-1.5, width=6, length=3, height=HALF, nibbles_on_off=false);
        }
        translate([0,0,-26]){
            piliers();
        }
        translate([-10,-6,-6]){
        cylinder(h = 10, r = 4);
        }
        translate([0,-6,-6]){
        cylinder(h = 10, r = 4);
        }
        translate([10,-6,-6]){
        cylinder(h = 10, r = 4);
        }

        translate([-10,6,-6]){
        cylinder(h = 10, r = 4);
        }
        translate([0,6,-6]){
        cylinder(h = 10, r = 4);
        }
        translate([10,6,-6]){
        cylinder(h = 10, r = 4);
        }        
        }
    }
}



/*********************************
Tube
**********************************/
/*
Le parametre remplissage sert à déterminer le remplissage du tube en %.
    Valeurs acceptées: 0 à 100
*/
module tube(remplissage = 0){

    translate([0,0,4]){
    //Bas du tube
    difference (){   
        scale([1, 1, 1]){    
            sphere(r = 3.75);
        }
        translate([0,0,5]){
            cube(size =[15,15,10], center = true);
        }
    }
    
    //Corps tube
    difference(){
        cylinder(h = 30, r = 3.75);
        translate([0,0,2]){
            cylinder(h = 30, r = 2.5);
        } 
    }
    
    //Remplissage du tube
        translate([0,0,2]){            
            if(remplissage <= 100){
                remplissage = remplissage*0.01*25;
                cylinder(h = remplissage, r = 2.5);
            }
            if(remplissage > 100){
                remplissage = 0;
                cylinder(h = remplissage, r = 2.5);
            }
             if(remplissage < 0){
                remplissage = 0;
                cylinder(h = remplissage, r = 2.5);
            }           
        }
    }
    
}



/*********************************
Bec bunsen
**********************************/
/*
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
*/
module becBunsen(lego=true){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionBecBunsen();            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionBecBunsen();
    }
    
    module constructionBecBunsen(){
        union(){
            //Bas du bec busen
            cylinder(h = 3, r = 12);
            translate([0,0,3]){
                cylinder(h = 3, r1 = 12, r2 = 4);
            }
            //Tube du cylindre
            translate([0,0,5]){
                cylinder(h = 20, r = 4);
            }
            //Flame
            translate([0,0,29]){
                difference(){
                    sphere(r=5);
                    cylinder(h = 7, r = 5);    
                }
                cylinder(h = 9, r1 = 5, r2= 0);
            }
        }
    }
}



/*********************************
Ernlenmeyer
**********************************/
/*
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le parametre remplissage sert à déterminer le remplissage de l'ernlenmeyer en %.
    Valeurs acceptées: 0 à 100
*/
module ernlenmeyer(lego=true, remplissage=0){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionErnlenmeyer(remplissage);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionErnlenmeyer(remplissage);
    }
    
    module constructionErnlenmeyer(remplissage){        
        translate([0,0,5]){
            difference(){
            union(){
                //Bas ernlenmeyer
                difference (){   
                    scale([1, 1, 0.5]){    
                        sphere(r = 12);
                    }
                    translate([-15,-15,0]){
                        cube(size =[30,30,20]);
                    }
                    translate([-15,-15,-25]){
                        cube(size =[30,30,20]);
                    }
                }
                //Centre ernlenmeyer
                difference(){
                    union(){
                        cylinder(h = 20, r1 = 12, r2 = 4);
                        translate([0,0,19]){
                            cylinder(h = 10, r = 4);
                        }
                    }
                    cylinder(h = 40, r = 3);                    
                }
                //Haut ernlenmeyer
                translate([0,0,30]){
                    difference(){
                        sphere(r = 4.5);
                        translate([-7.5,-7.5,2]){
                            cube(size =[15,15,10]);    
                        }
                        translate([-7.5,-7.5,-11.5]){
                            cube(size =[15,15,10]);    
                        }
                        translate([0,0,-5]){
                        cylinder(h = 10, r = 3);} 
                    }
                }
            }
            }//difference
                        
            //Remplissage du ernlenmeyer
            translate([0,0,2]){            
                if(remplissage <= 100){
                    remplissage = remplissage*0.01*28;
                    cylinder(h = remplissage, r = 4);
                }
                if(remplissage > 100){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 4);
                }
                 if(remplissage < 0){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 4);
                }           
            }
        }
    }
}


/*********************************
Support
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement le portoir
    Valeurs acceptées: true ou false
*/
module supportChauffer(lego=true, imprimer=true){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                piliers();
                if(imprimer==true){
                    translate([0,50,-4]){
                        hautSupport(lego);
                    }
                }
                if(imprimer==false){
                    translate([0,0,45]){
                        hautSupport(lego);
                    }
                }
            }
            
            doblo(col=-2.5, row=-2.5, width=5, length=5, height=HALF, nibbles_on_off=true);
        }
    }    
    //Sans Lego
    if(lego==false){
        union(){
            translate([0,0,4]){
                piliers();
                if(imprimer==true){
                    translate([0,50,-4]){
                        hautSupport(lego);
                    }
                }
                if(imprimer==false){
                    translate([0,0,45]){
                        hautSupport(lego);
                    }
                }
            }
            block(col=-2.5, row=-2.5, width=5, length=5, height=HALF, nibbles_on_off=false);
        }
    }
    
    //Piliers
    module piliers(){
        //Les piliers
        //Haut Gauche
        translate([-16,16,0]){
            cylinder(h = 48, r = 3);
        }
        //Haut Droite
        translate([16,16,0]){
            cylinder(h = 48, r = 3);
        }
        //Bas Gauche
        translate([-16,-16,0]){
            cylinder(h = 48, r = 3);
        }
        //Bas Droite
        translate([16,-16,0]){
            cylinder(h = 48, r = 3);
        }
    }    
    //Haut du support
    module hautSupport(lego=true){
    difference(){
        if(lego == true){
            block(col=-2.5, row=-2.5, width=5, length=5, height=HALF, nibbles_on_off=true);
        }
        if(lego == false){
            block(col=-2.5, row=-2.5, width=5, length=5, height=HALF, nibbles_on_off=false);
        }
        translate([-16,16,-7]){
            cylinder(h = 10, r = 3);
        }
        //Haut Droite
        translate([16,16,-7]){
            cylinder(h = 10, r = 3);
        }
        //Bas Gauche
        translate([-16,-16,-7]){
            cylinder(h = 10, r = 3);
        }
        //Bas Droite
        translate([16,-16,-7]){
            cylinder(h = 10, r = 3);
        }
    }
    }   
    
}





/*********************************
Microscope
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement le microscope
    Valeurs acceptées: true ou false
*/
module microscope(lego=true, imprimer=true){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                baseMicroscope();
                
                if(imprimer==true){                    
                    translate([0,11,8]){
                        centreMicroscope();
                    }                  
                    translate([-40,0,-4]){
                        lampeMicroscope();
                    }
                    translate([-40,25,13.5]){
                        rotate(a = [90,180,0]){
                            stage();
                        }
                    }
                    translate([35,0,-4]){
                        tubeOcculaire();
                    }
                    translate([35,20,-2]){
                        rotate(a = [200,0,0]){
                            lentille();
                        }
                    }
                    
                }
                if(imprimer==false){
                    translate([0,11,8]){
                        centreMicroscope();
                    }
                    translate([0,-2,11]){
                        lampeMicroscope();
                    }
                    translate([0,-6.5,29]){
                        stage();
                    }
                    translate([0,0,47]){
                        tubeOcculaire();
                    }
                    translate([0,0,47]){
                        lentille();
                    }
                }
                
            }
            
            doblo(col=-2.5, row=-4, width=5, length=7, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        union(){            
            baseMicroscope();
            if(imprimer==true){                
                translate([0,11,8]){
                    centreMicroscope();
                }                
                translate([-40,0,0]){
                    lampeMicroscope();
                }
                translate([-40,25,17.5]){
                    rotate(a = [90,180,0]){
                        stage();
                    }
                }
                translate([35,0,0]){
                    tubeOcculaire();
                }
                translate([35,20,2]){
                    rotate(a = [200,0,0]){
                        lentille();
                    }
                }
            }
            if(imprimer==false){
                translate([0,11,8]){
                    centreMicroscope();
                }
                translate([0,-2,11]){
                    lampeMicroscope();
                }
                translate([0,-6.5,29]){
                    stage();
                }
                translate([0,0,47]){
                    tubeOcculaire();
                }
                translate([0,0,47]){
                    lentille();
                }
            }            
        }
    }
    
    //Bas du microscope
    module baseMicroscope(){
        difference(){
            scale (v=[1,1.5,1]){
                cylinder(h = 8, r = 20);
            }
            translate([0,-15,-1]){
                scale (v=[1,1.5,1]){
                    cylinder(h = 10, r = 14);
                }
            }    
        }
    }
    
    //Centre du microscope
    module centreMicroscope(){
        difference(){
            union(){
                //Tronc
                translate([-4,0,30]){
                rotate(a = [90,0,90]){
                    difference(){
                        scale (v=[1,1.5,1]){
                            cylinder(h = 8, r = 20);
                        }
                        translate([-15,0,-1]){
                            scale (v=[1.5,1.2,1]){
                                cylinder(h = 10, r = 14);
                            }
                        }
                        translate([-15,0,0]){
                            cube(size =[20,70,25], center = true); 
                        }
                    }    
                }
                }
                //Parties latérales du tronc
                translate([3.5,0,2]){
                    rotate(a = [90,0,90]){
                    hull(){
                        translate([0,0,0]){ cylinder(r=2,h=3);}
                        translate([14,0,0]){ cylinder(r=2,h=3);}
                        translate([0,14,0]){ cylinder(r=2,h=3);}
                    }
                    }
                }
                translate([-7,0,2]){
                    rotate(a = [90,0,90]){
                    hull(){
                        translate([0,0,0]){ cylinder(r=2,h=3);}
                        translate([14,0,0]){ cylinder(r=2,h=3);}
                        translate([0,14,0]){ cylinder(r=2,h=3);}
                    }
                    }
                }
                //Boutons
                translate([3,0,54]){
                    rotate(a = [90,0,90]){
                        cylinder(h = 4, r = 4.5);
                    }    
                }
                translate([3,5,45]){
                    rotate(a = [90,0,90]){
                        cylinder(h = 4, r1 = 3, r2 = 2.5);
                    }    
                }
                translate([5,5,45]){
                    rotate(a = [90,0,90]){
                        cylinder(h = 4, r = 1.5);
                    }    
                }
            }
            //Trous pour joindre les autres pièces
            //Pour lampe
            translate([0,0,5]){
                rotate(a = [90,0,0]){
                    cylinder(h = 7, r = 2.1, $fn=30);
                }
            //Pour stage
            translate([0,-2,5]){
                cylinder(h = 8, r = 2.1, $fn=30);
            }
            //Pour tube occulaire
            translate([0,-2,51]){
                rotate(a = [90,0,0]){
                    cylinder(h = 5, r = 2.1, $fn=30);
                }
            }
            translate([0,-2,43]){
                rotate(a = [90,0,0]){
                    cylinder(h = 5, r = 2.1, $fn=30);
                }
            }
        }
        }
        
    }
    
    //Lampe Microscope
    module lampeMicroscope(){
        //Support Lampe    
        difference(){        
            cylinder(h = 4, r = 9);        
            translate([0,-5,-1]){
                cylinder(h = 6, r = 6);
            }
        }  
        //Lampe
        translate([0,-6,1]){    
            rotate(a = [9,0,0]){
                difference(){
                    cylinder(h = 4, r = 7);
                    translate([0,0,3]){
                        cylinder(h = 2, r = 5);
                    }
                }
            }
        }
        //Joint
        translate([0,13,2]){
            rotate(a = [90,0,0]){
                cylinder(h = 5, r = 2, $fn=30);
            }
        }        
    }
    
    //Stage Microscope
    module stage(){
        union(){
            //Stage
            cube(size =[35,35,5], center = true);
            //clips
            translate([10,0,3]){
                cube(size =[4,10,2], center = true);
            }
            translate([-10,0,3]){
                cube(size =[4,10,2], center = true);
            }
            //verre ovale
            translate([0,0,-2]){
                cylinder(h = 5, r = 5);
            }
            translate([0,0,-1.5]){
                cylinder(h = 5, r = 3);
            }
            //Joint
            translate([0,15.5,-10.5]){
                cylinder(h = 8, r = 2, $fn=30);        
            }
        }
    }
    
    //Tube occulaire microscope
    module tubeOcculaire(){
        difference(){
        union(){
            //Tube occulaire
            translate([0,0,20]){
                difference(){
                    cylinder(h = 18, r = 4);
                    translate([0,0,17]){
                        cylinder(h = 5, r = 3);
                    }    
                }
            }        
            cylinder(h = 20, r = 6);
            //Joints
            translate([0,9,8]){
                rotate(a = [90,0,0]){
                    cylinder(h = 4, r = 2, $fn=30);
                }
            }
            translate([0,9,16]){
                rotate(a = [90,0,0]){
                    cylinder(h = 4, r = 2, $fn=30);
                }
            }           
        }        
        //Trou pour joint
        translate([0,0,-1]){
            rotate(a = [-20,0,0]){
                cylinder(h = 3, r = 2.1, $fn=30);
            }
        }
        } 
    }
    
    //Lentille microscope
    module lentille(){
        difference(){
            union(){
                //Rond changer lentille
                translate([0,-6,0]){
                    rotate(a = [-20,0,0]){
                        cylinder(h = 4, r = 10);    
                        translate([0,0,-2]){
                            cylinder(h = 4, r1 = 8, r2= 10);
                        }    
                    }
                }
                //Lentilles
                translate([0,-4,-13]){
                    cylinder(h = 14, r = 2.5);
                }
                translate([6,-13,-7]){
                    rotate(a = [-30,0,30]){
                        cylinder(h = 10, r = 2.5);
                    }
                }
                translate([-6,-13,-8]){
                    rotate(a = [-30,0,-30]){
                        cylinder(h = 10, r = 2.5);
                    }
                }
            }            
            cylinder(h = 20, r = 6);            
        }       
        //Joint
        rotate(a = [-20,0,0]){
            cylinder(h = 2, r = 2, $fn=30);
        }        
    }
}



/*********************************
Ballon sphérique
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre remplissage sert à déterminer le remplissage du ballon sphérique en %.
    Valeurs acceptées: 0 à 100
Le paramètre tube2 sert à déterminer si on met un deuxième tube ou pas
    Valeurs acceptées: true ou false
Le paramètre tube3 sert à déterminer si on met un troisième tube ou pas
    Valeurs acceptées: true ou false
*/
module ballonSpherique(lego=true, remplissage=0, tube2=false, tube3=false){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionBallon(remplissage, tube2, tube3);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionBallon(remplissage, tube2, tube3);
    }
    
    module constructionBallon(remplissage, tube2, tube3){
        difference(){
            union(){
                //Rond
                difference(){
                    translate([0,0,10]){
                        sphere(r = 12);
                    }
                    translate([0,0,-5]){
                        cube(size =[30,30,10], center=true);
                    }
                }
                //Tube
                translate([0,0,20]){
                    cylinder(h = 15, r = 4);
                }
                //Haut ballon                                   
                translate([0,0,35]){
                    difference(){
                        sphere(r = 4.5);
                        translate([-7.5,-7.5,2]){
                            cube(size =[15,15,10]);    
                        }
                        translate([-7.5,-7.5,-11.5]){
                            cube(size =[15,15,10]);    
                        }
                        translate([0,0,-5]){
                            cylinder(h = 10, r = 3);
                        } 
                    }
                }
                //2ème tube
                if(tube2==true){                     
                    rotate(a=[0,-22,0]){
                        translate([0,0,33]){
                            translate([0,0,-15]){
                                difference(){
                                    cylinder(h = 15, r = 4);
                                    translate([0,0,-5]){
                                        cylinder(h = 25, r = 3);
                                    }
                                }
                            }
                            difference(){
                                sphere(r = 4.5);
                                translate([-7.5,-7.5,2]){
                                    cube(size =[15,15,10]);    
                                }
                                translate([-7.5,-7.5,-11.5]){
                                    cube(size =[15,15,10]);    
                                }
                                translate([0,0,-5]){
                                    cylinder(h = 10, r = 3);
                                } 
                            }
                        }
                    }
                }
                //3ème tube
                if(tube3==true){                     
                    rotate(a=[0,22,0]){
                        translate([0,0,33]){
                            translate([0,0,-15]){
                                difference(){
                                    cylinder(h = 15, r = 4);
                                    translate([0,0,-5]){
                                        cylinder(h = 25, r = 3);
                                    }
                                }
                            }
                            difference(){
                                sphere(r = 4.5);
                                translate([-7.5,-7.5,2]){
                                    cube(size =[15,15,10]);    
                                }
                                translate([-7.5,-7.5,-11.5]){
                                    cube(size =[15,15,10]);    
                                }
                                translate([0,0,-5]){
                                    cylinder(h = 10, r = 3);
                                } 
                            }
                        }
                    }
                }
                
            }
            //Partie vide           
            translate([0,0,3]){
                cylinder(h = 40, r = 3);
            }  
        }//difference
        
        //Remplissage du ballon sphérique
        translate([0,0,2]){            
            if(remplissage <= 100){
                remplissage = remplissage*0.01*33;
                cylinder(h = remplissage, r = 4);
            }
            if(remplissage > 100){
                remplissage = 0;
                cylinder(h = remplissage, r = 4);
            }
             if(remplissage < 0){
                remplissage = 0;
                cylinder(h = remplissage, r = 4);
            }           
        }
        
    }
}





/*********************************
Fiole
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre remplissage sert à déterminer le remplissage de la fiole en %.
    Valeurs acceptées: 0 à 100
*/
module fiole(lego=true, remplissage=0){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionFiole(remplissage);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionFiole(remplissage);
    }
    
    module constructionFiole(remplissage){        
        translate([0,0,5]){
            difference(){
            union(){
                //Bas fiole
                difference (){   
                    scale([1, 1, 0.6]){    
                        sphere(r = 12);
                    }
                    translate([-15,-15,5]){
                        cube(size =[30,30,20]);
                    }
                    translate([-15,-15,-25]){
                        cube(size =[30,30,20]);
                    }
                }                
                //Centre fiole
                translate([0,0,5]){
                    cylinder(h = 3, r1 = 8.5, r2 = 4);
                }
                translate([0,0,8]){
                    cylinder(h = 22, r = 4);
                }
                //Haut fiole
                translate([0,0,30]){
                    difference(){
                        sphere(r = 4.5);
                        translate([-7.5,-7.5,2]){
                            cube(size =[15,15,10]);    
                        }
                        translate([-7.5,-7.5,-11.5]){
                            cube(size =[15,15,10]);    
                        }
                        translate([0,0,-5]){
                        cylinder(h = 10, r = 3);}
                    }
                }                
            }
                translate([0,0,-2]){
                    cylinder(h = 40, r = 3);
                }
            }//difference
                        
            //Remplissage du ernlenmeyer
            translate([0,0,2]){            
                if(remplissage <= 100){
                    remplissage = remplissage*0.01*28;
                    cylinder(h = remplissage, r = 4);
                }
                if(remplissage > 100){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 4);
                }
                 if(remplissage < 0){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 4);
                }           
            }
        }
    }
}



/*********************************
Éprouvette
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre remplissage sert à déterminer le remplissage de l'éprouvette en %.
    Valeurs acceptées: 0 à 100
*/
module eprouvette(lego=true, remplissage=0){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionEprouvette(remplissage);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionEprouvette(remplissage);
    }
    
    module constructionEprouvette(remplissage){
        difference(){
            union(){
                //Socle
                cylinder(h = 3, r = 12);
                //Éprouvette       
                translate([0,0,3]){
                    cylinder(h = 34, r = 7);
                }        
                translate([-4,0,33]){
                    rotate(a=[0,-40,0]){
                        cylinder(h = 5, r = 3);                   
                    }
                }
            }//union
            translate([0,0,2]){
                cylinder(h = 40, r = 5);
            }
            translate([-7.5,-7.5,36.9]){
                cube(size =[15,15,10]);    
            }
            translate([-3.5,0,33]){
                rotate(a=[0,-40,0]){
                        cylinder(h = 7, r = 2);
                }
            }
            translate([-4,0,36]){
                rotate(a=[0,40,0]){
                    cube(size =[5,4,3], center=true);
                }
            }
        }//difference
        
        //Remplissage du ernlenmeyer
            translate([0,0,2]){            
                if(remplissage <= 100){
                    remplissage = remplissage*0.01*31;
                    cylinder(h = remplissage, r = 5);
                }
                if(remplissage > 100){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 5);
                }
                 if(remplissage < 0){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 5);
                }           
            }
    }
}



/*********************************
Entonnoir
**********************************/
/* 
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement l'entonnoir
    Valeurs acceptées: true ou false
*/
module entonnoir(imprimer=true){
    if(imprimer == false){
        constructionEntonnoir();
    }
    if(imprimer == true){
        rotate(a=[0,180,0]){
            translate([0,0,-20]){
                constructionEntonnoir();
            }
        }
    }
    
    
    module constructionEntonnoir(){
        difference(){
            union(){
                //Entonnoir forme
                cylinder(h = 10, r = 2.8, $fn=15);
                translate([0,0,10]){
                    cylinder(h = 10, r1 = 2.8, r2 = 12);
                }
            }
            //Vidage entonnoir
            translate([0,0,10]){
                cylinder(h = 11, r1 = 0, r2 = 10);
            }
            translate([0,0,-1]){
                cylinder(h = 15, r = 1.3, $fn=15);
            }
        }
    }
}




/*********************************
Balance
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
*/
module balance(lego=true){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionBalance();            
            }
            doblo(col=-2, row=-2, width=4, length=4, height=HALF, nibbles_on_off=false);
            block(col=-1.5, row=-1.5, width=3, length=3, height=HALF, up=HALF*3.5, nibbles_on_off=true);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionBalance();
        block(col=-1.5, row=-1.5, width=3, length=3, height=HALF, up=HALF*3, nibbles_on_off=false);
    }
    
    module constructionBalance(){
        hull(){
            //Petite base
            hull(){
                translate([-12,-12,0]){
                    cylinder(h = 3, r = 4);
                }
                translate([-12,12,0]){
                    cylinder(h = 3, r = 4);
                }
                translate([12,12,0]){
                    cylinder(h = 3, r = 4);
                }
                translate([12,-12,0]){
                    cylinder(h = 3, r = 4);
                }
            }
            //Base
            block(col=-1.5, row=-1.5, width=3, length=3, height=HALF, up=HALF*1.5, nibbles_on_off=false);        
        }
        //Support de la balance        
        block(col=-1.375, row=-1.375, width=2.75, length=2.75, height=HALF/2, up=HALF*2.5, nibbles_on_off=false);
        //Texte sur la balance
        content = "0.00";
        font = "Liberation Sans";
        translate([-5,-14,4]){
            rotate(a=[70,0,0]){
                linear_extrude(height = 2) {
                    text(content, font = font, size = 6);
                }
            }
        }
        
    }

}





/*********************************
Flacon
**********************************/
/*
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre remplissage sert à déterminer le remplissage du flacon en %.
    Valeurs acceptées: 0 à 100
*/
module flacon(lego=true, remplissage=0){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionFlacon(remplissage);            
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionFlacon(remplissage);
    }
    
    module constructionFlacon(remplissage){
        translate([0,0,5]){
            difference(){
                union(){
                    //Bas Flacon
                    difference (){   
                        scale([1, 1, 0.5]){    
                            sphere(r = 12);
                        }
                        translate([-15,-15,0]){
                            cube(size =[30,30,20]);
                        }
                        translate([-15,-15,-25]){
                            cube(size =[30,30,20]);
                        }
                    }
                    //Corps flacon
                    cylinder(h = 17, r = 12);
                    //Haut flacon
                    translate([0,0,17]){
                        difference (){   
                            scale([1, 1, 0.5]){    
                                sphere(r = 12);
                            }
                            translate([-15,-15,-10]){
                                cube(size =[30,30,10]);
                            }
                            translate([-15,-15,5.65]){
                                cube(size =[30,30,10]);
                            }
                        }
                    }
                    //Tube haut du flacon
                    translate([0,0,20]){
                        cylinder(h = 10, r = 4);                
                    }
                    //Haut flacon
                    translate([0,0,30]){
                        difference(){
                            sphere(r = 4.5);
                            translate([-7.5,-7.5,2]){
                                cube(size =[15,15,10]);    
                            }
                            translate([-7.5,-7.5,-11.5]){
                                cube(size =[15,15,10]);    
                            }
                            translate([0,0,-5]){
                            cylinder(h = 10, r = 3);} 
                        }
                    }
                }//union                
                cylinder(h = 40, r = 3);                
            }//difference
            
            //Remplissage du flacon
            translate([0,0,2]){            
                if(remplissage <= 100){
                    remplissage = remplissage*0.01*28;
                    cylinder(h = remplissage, r = 3);
                }
                if(remplissage > 100){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 3);
                }
                 if(remplissage < 0){
                    remplissage = 0;
                    cylinder(h = remplissage, r = 3);
                }           
            }
        }
    }
}




/*********************************
Bouchon
**********************************/
/* 
/!\ ATTENTION: Pour que le bouchon puisse réellement bien boucher les récipients il est conseillé de l'imprimer avec du PLASTIC MOU !
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement le bouchon
    Valeurs acceptées: true ou false
*/
module bouchon(imprimer=true){
    if(imprimer == false){
        cylinder(h = 7, r1 = 2, r2 = 5);
    }
    if(imprimer == true){
        rotate(a=[180, 0, 0]){
            translate([0,0,-7]){
                cylinder(h = 7, r1 = 2, r2 = 5);
            }
        }
    }
}




/*********************************
Pince pour récipient
**********************************/
/* 
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement la pince
    Valeurs acceptées: true ou false
*/
module pince(imprimer=true){
    
    if(imprimer == true){
        translate([0,-12,8]){
            rotate(a=[180, 0, 0]){
                tige();
            }
        }
        translate([0,12,8]){
            rotate(a=[180, 0, 0]){
                tige();
            }
        }
        
        translate([15,10,3]){
            joint();
        }
        translate([25,10,9]){
            rotate(a=[180, 0, 0]){
                joint2();
            }
        }
    }
    if(imprimer == false){
        translate([0,-8,0]){
            tige();
        }
        translate([0,8,8]){
            rotate(a=[180, 0, 0]){
                tige();
            }
        }
        
        joint();
        translate([0,0,2]){
            joint2();
        }
    }
    
    
    module tige(){
        //Rond
        difference(){
            cylinder(h = 8, r= 8);
            translate([0,0,-1]){
                cylinder(h = 10, r= 5);
            }
        }
        //tige collée au rond
        difference(){
            union(){
                translate([7,0,4]){
                    rotate(a=[0, 90, 0]){
                        cylinder(h = 30, r= 4);
                    }
                }
                difference(){
                    union(){
                        translate([37,0,4]){
                            sphere(r = 4, $fn=15);
                        }
                        translate([37,0,4]){
                            rotate(a=[0, 90, 40]){
                                cylinder(h = 20, r= 4);
                            }
                        }
                    }
                    translate([45,5,1]){
                        cube(size =[20,25,6], center=true);                        
                    }
                }
            }
            //Trou pour joint
            translate([46,8,2]){
                cylinder(h = 8, r= 2, $fn=15);
            }
        }
        //Exrémité
        translate([65,0.75,0]){
            difference(){
                translate([0,0,0]){
                    cylinder(h = 8, r= 21);
                }
                translate([0,0,-1]){
                    cylinder(h = 10, r= 15);
                }
                translate([-13,-7,3]){
                    cube(size =[20,34,15], center=true);
                }
                translate([10,-8,3]){                    
                    cube(size =[30,30,15], center=true);
                }
                translate([-18,5,3]){
                    rotate(a=[0, 0, 40]){
                        cube(size =[15,15,15], center=true);
                    }
                }
            }
        }
    }
    
    //Joint
    module joint(){    
        translate([46,0,-2]){
            cylinder(h = 12, r= 2, $fn=15);
        }
        translate([46,0,-3]){
            cylinder(h = 3, r= 3, $fn=15);
        }        
    }
    
    module joint2(){
        translate([46,0,9]){
            rotate(a=[180, 0, 0]){
                difference(){
                cylinder(h = 3, r= 3, $fn=15);
                    translate([0,0,1]){
                        cylinder(h = 3, r= 2, $fn=15);
                    }    
                }
            }
        }   
    }
    
}







/*********************************
Pissette
**********************************/
/* 
/!\ ATTENTION: Pour que le bouchon puisse réellement bien boucher les récipients il est conseillé de l'imprimer avec du PLASTIC MOU 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
*/
module pisette(lego=true){
    //avec Lego
    if(lego==true){
        union(){
            translate([0,0,4]){
                constructionPisette();
                
                translate([0,0,25]){
                    bouchon();
                }                
            }
            doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);
        }
    }    
    //Sans Lego
    if(lego==false){
        constructionPisette();
        
        translate([0,0,25]){
            bouchon();
        }   

    }
    
    //Pisette
    module constructionPisette(){
        difference(){
            union(){                    
                //Corps flacon
                cylinder(h = 22, r = 10);
                //Haut flacon
                translate([0,0,22]){
                    difference (){   
                        scale([1, 1, 0.5]){    
                            sphere(r = 10);
                        }
                        translate([-15,-15,-10]){
                            cube(size =[30,30,10]);
                        }
                        translate([-15,-15,5.65]){
                            cube(size =[30,30,10]);
                        }
                    }
                }
            }//union 
            //trou bouchon
            translate([0,0,22.5]){
                cylinder(h = 10, r = 3, $fn=15);
            } 
            //trou haut pisette
            translate([0,0,22]){
                difference (){   
                    scale([1, 1, 0.5]){    
                        sphere(r = 8);
                    }
                    translate([-15,-15,-11]){
                        cube(size =[30,30,10]);
                    }
                }
            }
            //Trou pour corps
            translate([0,0,2]){
                cylinder(h = 20, r = 8);
            }  
            
        }//difference  
    }
    
    //Bouchon
    module bouchon(){
        difference(){
            union(){
                difference(){
                    cylinder(h = 5, r = 9); 
                    translate([0,0,-1]){
                        cylinder(h = 5, r = 2.25, $fn=15);
                    }           
                }
                //Paille
                translate([0,0,5]){
                    cylinder(h = 15, r = 2.75, $fn=15);
                }                
            }
            //trou pour paille
            translate([0,0,-2]){
                cylinder(h = 25, r = 1.5, $fn=15);
            }
        }        
    } 
}









/*********************************
Vis
**********************************/
/* 
/!\ Le module Vis permet de créer des mécanismes de vis
Le paramètre hauteur sert à déterminer la hauteur de la vis
    Valeurs acceptées: numérique positive
Le paramètre rayon sert à déterminer le rayon de la vis 
    Valeurs acceptées: numérique positive
Le paramètre visrayon sert à déterminer la grosseur du mécanisme de vis
    Valeurs acceptées: numérique 
Le paramètre hautRotation nous dit à quelle hauteur une rotation complète de la partie vissée est réalisée
    Valeurs acceptées: numérique positif
*/
module vis(hauteur, rayon, visrayon, hautRotation){
    //On doit mettre une hauteur positive!
    if(hauteur > 0){        
        //On va calculer la rotation en fonction de la hauteur. 
        rotation = (hauteur/hautRotation)*360;
        
        union(){
                //cylindre qui contient la vise
                cylinder(h = hauteur, r = rayon, $fn=15);
                //Vis
                linear_extrude(height = hauteur, center = false, convexity = 10, twist = -rotation, slices=2000, $fn=15){
                translate([rayon-visrayon*0.4, 0, 0]){
                    circle(r = visrayon);
                }
            }
        }
    }    
}







/*********************************
Noix double
**********************************/
/* 
Le paramètre imprimer sert à placer les pièces de façon à imprimer facilement la noix double
    Valeurs acceptées: true ou false
*/
module noixDouble(imprimer = true){
    
    if(imprimer == false){
        cylindre1();
        cylindre2();
        translate([0,0,-4]){
            esse();
        }
        vis1();
        vis2();        
    }
    
    if(imprimer == true){
        cylindre1();
        cylindre2();
        translate([0,0,-4]){
            esse();
        }
        
        rotate(a=[0, -90, 0]){
            translate([8,25,10]){
                vis1();
            }
        }
        rotate(a=[0, 90, 0]){
            translate([-65,25,10]){
                vis2();
            }
        }
    }
    
    
    module cylindre1(){
        difference(){
            translate([0,0,8]){
                rotate(a=[0, 90, 0]){
                    cylinder(h = 5, r = 8);                           
                    
                }
            }       
            translate([-2, 0, 8]){
                rotate(a=[0, 90, 0]){
                    vis(8.5, 3.3, 1.6, 10);
                }
            }        
        }
    }
    
    module cylindre2(){
        difference(){
            translate([52,0,8]){
                rotate(a=[0, 90, 0]){
                    cylinder(h = 5, r = 8);                   
                }
            }
            translate([50, 0, 8]){
                rotate(a=[0, 90, 0]){
                    vis(8.5, 3.3, 1.6, 10);
                }
            }
        }
    }
    
    
    //Forme en S
    module esse(){
        difference(){
            union(){
                translate([15,3,4]){
                    difference(){
                        cylinder(h = 16, r = 15);
                        translate([0,0,-1]){
                            cylinder(h = 20, r = 12);
                        }
                        translate([0,-10,3]){
                            cube(size =[40,20,30], center=true);
                        }                        
                    }                    
                }
                translate([27,-3,4]){
                        cube(size =[3,6,16]);
                    }
                translate([42,-3,4]){
                    difference(){
                        cylinder(h = 16, r = 15);
                        translate([0,0,-1]){
                            cylinder(h = 20, r = 12);
                        }
                        translate([0,10,3]){
                            cube(size =[40,20,30], center=true);
                        }
                    }
                }
            }//union
            translate([0,0,12]){
                rotate(a=[0, 90, 0]){
                    cylinder(h = 5, r = 8);
                }
            }
            translate([52,0,12]){
                rotate(a=[0, 90, 0]){
                    cylinder(h = 5, r = 8);
                }
            }            
        }//difference
                
    }
        
    
    //vis
    module vis1(){
        translate([-8, 0, 8]){
            rotate(a=[0, 90, 0]){
                vis(35, 3, 1.6, 10);
            }
        }
        translate([-6.5, 0, 0]){
            cylinder(h = 16, r = 1.5, $fn=15);
        }
    }
    
    module vis2(){
        translate([30, 0, 8]){
            rotate(a=[0, 90, 0]){
                vis(35, 3, 1.6, 10);
            }
        }
        translate([63.5, 0, 0]){
            cylinder(h = 16, r = 1.5, $fn=15);
        }
    }
    
}








/*********************************
Vis pour la noix double
**********************************/
/* 
Ce module permet de pouvoir imprimer une vis pour la noix double.
*/
module visSolo(){
    rotate(a=[0, -90, 0]){
        translate([8,0,-8]){
            translate([-8, 0, 8]){
                rotate(a=[0, 90, 0]){
                    vis(35, 3, 1.6, 10);
                }
            }
            translate([-6.5, 0, 0]){
                cylinder(h = 16, r = 1.5, $fn=15);
            }        
        }
    }
}








/*********************************
Pilier
**********************************/
/* 
Le paramètre lego sert à déterminer si on met une base lego ou pas
    Valeurs acceptées: true ou false
Le paramètre hauteur sert à déterminer la hauteur du pilier
    Valeurs acceptées: entier positif
*/
module pilier(lego=true, hauteur=10){
    
    if(lego == true){
        doblo(col=-1.5, row=-1.5, width=3, length=3, height=HALF, nibbles_on_off=false);

        translate([-5, -5, 3]){
            cube(size =[10,10,hauteur]);
        }
    }
    if(lego == false){
        translate([-5, -5, 0]){
            cube(size =[10,10,hauteur]);
        }
    }
}
